<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config_value('site_name', 'Edge') }} - @yield('title', 'Home')</title>
    <link rel="icon" href="{{ config_value('site_favicon', asset('images/logo_fix.png')) }}" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    @vite(['resources/scss/app.scss', 'resources/js/app.js'])

    <style>
        :root {
            --primary-color: {{ config_value('primary_color', '#4B8BFF') }};
            --primary-dark: {{ config_value('primary_dark', '#4179E6') }};
            --primary-light: {{ config_value('primary_light', '#80A9FF') }};
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="app-wrapper">
        <header class="main-header">
            <div class="container">
                <div class="header-content">
                    {{-- Logo --}}
                    <div class="logo">
                        <a href="{{ route('home') }}">
                            <img src="{{ config_value('site_logo', asset('images/logo_fix.png')) }}" alt="Logo">
                        </a>
                    </div>

                    {{-- Desktop Navigation --}}
                    <nav class="main-nav" id="mainNav">
                        <ul>
                            <li><a href="{{ route('home') }}" class="{{ request()->routeIs('home') ? 'active' : '' }}">Home</a></li>
                            <li><a href="{{ route('forum.index') }}" class="{{ request()->routeIs('forum.*') ? 'active' : '' }}">Forum</a></li>
                            @if(!!config_value('store_enabled'))
                                <li><a href="{{ route('store.index') }}" class="{{ request()->routeIs('store.*') ? 'active' : '' }}">Store</a></li>
                            @endif
                            <li class="nav-dropdown">
                                <a href="#" class="{{ request()->routeIs('community.*') ? 'active' : '' }}">
                                    Community <i class="fas fa-chevron-down"></i>
                                </a>
                                <div class="nav-dropdown-menu">
                                    <a href="{{ route('users.index') }}" class="nav-dropdown-item">Users</a>
                                    <a href="{{ route('map') }}" class="nav-dropdown-item">Interactive Map</a>
                                    @if(!!config_value('toggle_news'))
                                        <a href="{{ route('news.index') }}" class="nav-dropdown-item">News</a>
                                    @endif
                                </div>
                            </li>
                        </ul>
                    </nav>

                    {{-- Right Side Actions --}}
                    <div class="header-actions">
                        @auth
                            {{-- Notification Bell --}}
                            <div class="header-notification-container" id="header-notification-container">
                                <button class="header-notification-bell" aria-label="Notifications">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path>
                                        <path d="M13.73 21a2 2 0 0 1-3.46 0"></path>
                                    </svg>
                                    <span class="header-notification-badge is-hidden" id="header-notification-badge">0</span>
                                </button>
                                
                                <div class="header-notification-dropdown" id="header-notification-dropdown">
                                    <div class="header-notification-header">
                                        <h3>Notifications</h3>
                                        <a href="#" class="header-mark-all-read">Mark all read</a>
                                    </div>
                                    
                                    <div class="header-notification-list" id="header-notification-list">
                                        <div class="header-notification-loading">Loading...</div>
                                    </div>
                                    
                                    <div class="header-notification-footer">
                                        <a href="{{ route('notifications.index') }}" class="header-view-all-link">View all notifications</a>
                                    </div>
                                </div>
                            </div>

                            {{-- User Dropdown --}}
                            <div class="user-dropdown" id="userDropdown">
                                <div class="user-info">
                                    <img src="{{ auth()->user()->avatar }}" alt="{{ auth()->user()->name }}" class="avatar">
                                    <span>{{ auth()->user()->name }}</span>
                                </div>
                                <div class="dropdown-menu" id="userDropdownMenu">
                                    <a href="{{ route('profile.show') }}" class="dropdown-item">
                                        <i class="fas fa-user"></i>
                                        <span>Profile</span>
                                    </a>
                                    <a href="{{ route('notifications.index') }}" class="dropdown-item">
                                        <i class="fas fa-bell"></i>
                                        <span>Notifications</span>
                                        <span class="dropdown-notification-badge" id="dropdown-notification-badge" style="display: none;">0</span>
                                    </a>
                                    <a href="{{ route('store.purchase-history') }}" class="dropdown-item">
                                        <i class="fas fa-shopping-cart"></i>
                                        <span>Purchases</span>
                                    </a>
                                    @can('access dashboard')
                                        <a href="{{ route('admin.dashboard') }}" class="dropdown-item">
                                            <i class="fas fa-cog"></i>
                                            <span>Admin Panel</span>
                                        </a>
                                    @endcan
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item">
                                            <i class="fas fa-sign-out-alt"></i>
                                            <span>Logout</span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @else
                            {{-- Auth Buttons --}}
                            <div class="auth-buttons">
                                <a href="{{ route('login.steam') }}" class="btn-steam">
                                    <i class="fa-brands fa-steam"></i> 
                                    <span>Login with Steam</span>
                                </a>
                            </div>
                        @endauth

                        {{-- Mobile Menu Toggle --}}
                        <button class="mobile-nav-toggle" aria-label="Toggle menu">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        {{-- Mobile Menu Overlay --}}
        <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>

        <main class="main-content">
            @yield('content')
        </main>

        <footer class="main-footer">
            <div class="container">
                <div class="footer-content">
                    <div class="footer-logo">
                        <img src="{{ config_value('site_logo', asset('images/logo_fix.png')) }}" alt="Logo">
                        <p>{{ config_value('footer_text') }}</p>
                    </div>
                    <div class="footer-links">
                        <div class="link-group">
                            <h4>Links</h4>
                            <ul>
                                <li><a href="{{ route('home') }}">Home</a></li>
                                <li><a href="{{ url('/#servers') }}">Servers</a></li>
                                <li><a href="{{ route('store.index') }}">Store</a></li>
                                <li><a href="{{ route('forum.index') }}">Forums</a></li>
                            </ul>
                        </div>
                        <div class="link-group">
                            <h4>Community</h4>
                            <ul>
                                @if(config_value('discord_invite') != "")
                                    <li><a href="{{ config_value('discord_invite') }}">Discord</a></li>
                                @endif
                                @if(config_value('steam_group') != "")
                                    <li><a href="https://steamcommunity.com/group/{{ config_value('steam_group') }}">Steam Group</a></li>
                                @endif
                                <li><a href="{{ route('users.index') }}">Users</a></li>
                            </ul>
                        </div>
                        @if(config_value('show_legal_footer', true))
                        <div class="link-group">
                            <h4>Legal</h4>
                            <ul>
                                <li><a href="{{ route('store.tos') }}">Terms of Service</a></li>
                                <li><a href="{{ route('privacy.policy') }}">Privacy Policy</a></li>
                            </ul>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </footer>
    </div>

    @auth
    {{-- Notification Data for JavaScript --}}
    <script>
        window.notificationRoutes = {
            recent: '{{ route('notifications.recent') }}',
            unreadCount: '{{ route('notifications.unread-count') }}',
            markAllRead: '{{ route('notifications.mark-all-read') }}',
            markRead: '/notifications/:id/read',
            notificationsIndex: '{{ route('notifications.index') }}'
        };
    </script>
    @endauth
    
    @stack('scripts')
    @stack('inline-scripts')
</body>
</html>